@extends('admin.layout.page-app')
@section('page_title', __('label.group_battles'))
@section('tab_title', __('label.group_battles'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.group_battles')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.group_battles.index') }}">{{__('label.group_battles')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.group_battles_details')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.group_battles.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.group_battles')}}</a>
				</div>
			</div>

            <!-- Created User -->
            <div class="profile-card mt-3">
                <div class="profile-header"></div>
                <div class="row p-4 ml-4">
                    <div class="col-md-2">
                        <img src="{{ $data['created_user']['image'] ?? asset('assets/imgs/default.png') }}" class="profile-picture">
                        <h5 class="mt-2 primary-color">{{ $data['created_user']['full_name'] ?? '' }}</h5>
                    </div>
 
                    <div class="col-md-10">
                        <div class="row profile-details" >
                            <div class="col-md-6">
                                <p><strong>{{__('label.room')}} :</strong> {{ $data['room_code'] ?? '-' }}</p>
                                <p><strong>{{__('label.name')}} :</strong> {{ $data['name'] ?? '-' }}</p>
                                <p><strong>{{__('label.total_questions')}} :</strong> {{ $data['total_questions'] ?? '0' }}</p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>{{__('label.joining_coin')}} :</strong> {{ $data['joining_coin'] ?? '0' }}</p>
                                <p><strong>{{__('label.winning_coin')}} :</strong> {{ $data['winning_coin'] ?? '0' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                @for ($i=0; $i < count($leaderboard); $i++)
                    <div class="col-4">
                        <div class="card custom-border-card mt-3 bg-card-gradient">
                            <div class="d-flex align-items-center mb-3">
                                <img src="{{ $leaderboard[$i]['user']['image'] ?? asset('assets/imgs/default.png') }}" class="profile-picture rounded-circle mt-0" width="60" height="60">
                                <div class="ml-4 text-left">
                                    <h4>{{ $leaderboard[$i]['user']['full_name'] ?? '' }}</h4>
                                    <h5>{{__('label.attended')}} : {{ $leaderboard[$i]['questions_attended'] ?? 0 }}</h5>
                                    <h5>{{__('label.correct')}} : {{ $leaderboard[$i]['correct_answers'] ?? 0 }}</h5>
                                    <h5>{{__('label.percentage')}} : {{ $leaderboard[$i]['percentage'] ?? 0 }}%</h5>
                                </div>
                            </div>

                            @if ($leaderboard[$i]['is_winner'] == 1)
                                <span class="badge green-bg mt-2">{{ __('label.winner') }}</span>
                            @endif
                        </div>
                    </div>
                @endfor
            </div>
        </div>
    </div>
@endsection
